<?php

namespace App\Imports;

use App\Models\Journal;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\CompteSubdivisionnaire;
use App\Models\SousCompte;
use App\Models\CodeJournaux;
class JournalsImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
      $Compte = CompteSubdivisionnaire::whereNumerocompteAndEtat($row['compte'],0)->first();
      $SCompte = SousCompte::whereNumerocompteAndEtat($row['sous_compte'],0)->first();
      $CodeJournaux = CodeJournaux::whereCodeAndEtat($row['journal_code'],0)->first();
      if (is_null($CodeJournaux)) {
      if (!is_null($Compte)) {
        if (is_null($SCompte)) {
            if ($row['type']==1) {

                return new Journal([
                    'Compte'=> $Compte->id,
                    'Sous_compte'=> null, 
                    'journal_id'=>$CodeJournaux->id,
                    'TypeMvt'=>$row['type'],
                    'DateOperation'=>$row['dateoperation'],
                    'Piece'=>$row['piece'],
                    'MD'=> $row['montant'],
                    'Libelle'=>$row['libelle'],
                    'Exercice'=>$row['exercice'],
                    'created_by'=>auth()->user()->id,
                    'updated_by'=>auth()->user()->id
                ]);
                
            }elseif($row['type']==2){
                return new Journal([
                    'Compte'=> $Compte->id,
                    'Sous_compte'=> null, 
                    'journal_id'=>$CodeJournaux->id,
                    'TypeMvt'=>$row['type'],
                    'DateOperation'=>$row['dateoperation'],
                    'Piece'=>$row['piece'],
                    'MC'=> $row['montant'],
                    'Libelle'=>$row['libelle'],
                    'Exercice'=>$row['exercice'],
                    'created_by'=>auth()->user()->id,
                    'updated_by'=>auth()->user()->id
                ]);
            }
            
        }else{
            if ($row['type']==1) {
                return new Journal([
                    'Compte'=> $Compte->id,
                    'Sous_compte'=> $SCompte->id,
                    'journal_id'=>$CodeJournaux->id, 
                    'TypeMvt'=>$row['type'],
                    'DateOperation'=>$row['dateoperation'],
                    'Piece'=>$row['piece'],
                    'MD'=> $row['montant'],
                    'Libelle'=>$row['libelle'],
                    'Exercice'=>$row['exercice'],
                    'created_by'=>auth()->user()->id,
                    'updated_by'=>auth()->user()->id
                ]);
            }elseif($row['type']==2){
                return new Journal([
                    'Compte'=> $Compte->id,
                    'Sous_compte'=> $SCompte->id, 
                    'journal_id'=>$CodeJournaux->id,
                    'TypeMvt'=>$row['type'],
                    'DateOperation'=>$row['dateoperation'],
                    'Piece'=>$row['Piece'],
                    'MC'=> $row['montant'],
                    'Libelle'=>$row['libelle'],
                    'Exercice'=>$row['exercice'],
                    'created_by'=>auth()->user()->id,
                    'updated_by'=>auth()->user()->id
                ]);
            }
        }  
      }
     }
    }
}
