@extends('layout.base')
@section('content')                        
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
              <div class="card-header">
                <h3 class="card-title">Les Etat Financiers</h3>
                @can('compte_principal-create')
                <div class="row">
                  <div class="col-md-8"></div>
                  <div class="col-4">
                   <a href="javascript:void(0)" data-toggle="modal" data-target="#add-new-event" class="btn m-t-20 btn-info btn-block waves-effect waves-light">
                        <i class="ti-plus"></i> Nouvel Etat Financier
                    </a>
                  </div>
                </div>
                @endcan
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-striped">
                  <thead>
                    <tr>
                        <th>Etat</th>
                        <th>Type Etat</th>
                        <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach($EtatFinanciers as $EtatFinancier)
                      <tr>
                        <td>{{$EtatFinancier->intitule}}</td>
                        <td>{{$EtatFinancier->type_etat}}</td>
                      <td>
                        @can('compte_principal-delete')
                        <form action="{{route('destroy_EtatFinancier', $EtatFinancier->id)}}" method='POST' style='display: inline-block;' onsubmit="return confirm('Etez-vous sur de cette Operation ?')">
                        {{csrf_field()}}
                        {{method_field('DELETE')}}
                        <button onclick="return confirm('Etez -vous sur de cette Operation ?')"><i class='fas fa-trash'></i>
                        </button>
                        </form>
                        @endcan
                        <a href="{{route('Add_Section',$EtatFinancier->id)}}">Settings</a>
                                                </td>
                                              </tr>
                                           @endforeach
                                         </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
            </div>
        </section>
      </div>

                     <!-- Modal Add Category -->
                <div class="modal fade none-border" id="add-new-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Creer un Compte</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>
                        <form method="POST" action="{{ route('store_EtatFinancier')}}">
                            <div class="modal-body">
                               
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <div class="col-md-12">
                                          
                                            <label class="control-label">Intitulé *</label>
                                            <input class="form-control form-white" placeholder="Intitule" type="text" name="intitule" />
                                            {!! $errors->first('intitule', '<span class="error">:message</span>') !!}

                                  
                                      <label class="col-md-3">Type d'Etat *</label>
                                    
                                        <select class="form-control select2" name="type_etat">
                                              <option value="Bilan">Bilan</option>
                                              <option value="Compte_Resultat">Compte_Resultat</option>
                                              <option value="Flux_Tresorerie">Flux_Tresorerie</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>
        
                        @endsection
                                  