# parse-filepath [![NPM version](https://badge.fury.io/js/parse-filepath.svg)](http://badge.fury.io/js/parse-filepath)

> Parse a filepath into an object, yielding predictable results for basename and extname.

## Install
### Install with [npm](npmjs.org)

```bash
npm i parse-filepath --save
```

## Usage

```js
var parsePath = require('parse-filepath');
parsePath('foo/bar/baz/index.md.html');

// returns
{
  name: 'index',
  dirname: 'foo/bar/baz',
  extname: '.md.html',
  basename: 'index.md.html',
  extSegments: ['.md', '.html']
}
```

## Differences from node.js path

Given the following string:

```js
var str = 'foo/bar/baz/quux.min.js';
```

#### .basename

Node.js:

* `path.basename(str)` => `quux.min.js`
* `path.basename(str, path.extname(str))` => `quux.min` **whaaaaa!?**

parse-filepath:

* `parsePath(str).basename` => `quux.min.js`
* `parsePath(str).name` => `quux`


#### .extname

Node.js:

* `path.extname(str)` => `.js`

parse-filepath

* `parsePath(str).extname` => `.min.js`


#### .dotfiles

As an example, `.travis.yml` is parsed to:

```js
{
  name: 'travis',
  dirname: '.',
  extname: '.yml',
  basename: '.travis.yml',
  extSegments: ['.yml']
}
```

And `.gitignore` is parsed to:

```js
{
  name: 'gitignore',
  dirname: '.',
  extname: '',
  basename: '.gitignore',
  extSegments: []
}
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on November 13, 2014._