<?php

namespace App\Models;
use App\Models\Repportage;
use App\Models\Journal;
use App\Interfaces\IExerciceComptable as IExerciceComptable;
use Illuminate\Database\Eloquent\Model;

class ExerciceComptable extends Model implements IExerciceComptable
{
    protected $fillable = ['Debut', 'Fin', 'NbreDecimal', 'separateurDecimal', 'separateurMilieu', 'Etat', 'Devise', 'Cloturer', 'Editorial_mode'];

    public static function UniqueExercice ($Debut, $Fin)
    {
    	$NbreExercice = ExerciceComptable::whereDebutAndFin($Debut, $Fin)->count();
    	//$Diff = $Fin-$Debut;

    	if ($NbreExercice > 0) {
    		return false;
    	}else{
    		return true;
    	}
    }

    public static function VerifyNbreDecimal($value)
    {
    	if (preg_match("#[0-9]{1}#",$value)) {
    		return true;
    	}
    }

    public static function VerifyseparateurDecimalseparateurMilieu($value, $value1)
    {
    	if (preg_match("#^[,\.]$#",$value) AND preg_match("#^[,\.]$#",$value1)) {
    		return true;
    	}
    }


    public function isUsed($exercice){
       $Nbre = Repportage::whereReportedIn($exercice)->count('id');
       $NbreJ = Journal::whereExercice($exercice)->count('id');

       $Nbre+=$NbreJ;

       if ($Nbre>0) {
           return false;
       }else{
          return true;
       }
    }
}
