<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EtatFinanciers extends Model
{
    use HasFactory;
    protected $fillable = ['intitule', 'type_etat', 'Section', 'Positionnement'];

    public function setSectionAttribute($value)
    {  
       $texteMajuscule = strtoupper($value);
       $this->attributes['Section'] = $texteMajuscule;
    }

    public function setIntituleAttribute($value)
    {  
       $texteMinuscule = strtolower($value);
       $this->attributes['intitule'] = ucwords($texteMinuscule);
    }
}
