<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompteGeneral extends Model
{
    use HasFactory;
    protected $fillable = ['numero_compte', 'Intitule', 'Categorie', 'Etat', 'tiers', 'resultat_exercice', 'soldeJournalier','type_compte', 'Repport'];

    public static function UniqueCompte($value)
    {
    	$Nbre = ComptePrincipal::whereNumerocompte($value)->count('id');
    	if ($Nbre == 0) {
    		return true;
    	}
    }

    public function setNumeroCompteAttribute($value)
    {  
       $searchString = " ";
       $replaceString = "";
       $outputString = str_replace($searchString, $replaceString, $value); 

       while(strlen($outputString) < session()->get('longeur')) {
       	  $outputString.='0';
       }	
       $this->attributes['numero_compte'] = $outputString;
    }

    public function setIntituleAttribute($value)
    {  
       $texteMinuscule = strtolower($value);
       $this->attributes['Intitule'] = ucwords($texteMinuscule);
    }
}
