<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use DB;
use App\Models\SousClasse;
use App\Http\Requests\FormRequestSclasse;
use App\Models\Type;
class SousClasseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   $Classes = Type::all();
        $SClasses = DB::table('sous_classes')
                    ->join('types', 'types.id', '=', 'sous_classes.classe_id')
                    ->select(DB::raw('sous_classes.id, sous_classes.Intitule, sous_classes.Sclasse,types.Types'))
                    ->get();
        return view('Comptabilite\SClasse.index', compact('SClasses', 'Classes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(FormRequestSclasse $request)
    {
        SousClasse::create([
            'Sclasse'=>$request->SClasse,
            'Intitule'=>$request->Intitule,
            'classe_id'=>$request->Classe
        ]);

        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getSClasseId(Request $request){
        $TypeComptes = Type::whereEtat(0)->get();
        $CompteId = $request->get('Sclasse');

        $Compte =DB::table('types')
                ->join('sous_classes', 'sous_classes.classe_id', '=', 'types.id')
                ->select(DB::raw('types.Types,types.Class, types.id as Tid, sous_classes.id, sous_classes.Sclasse,sous_classes.Intitule'))
                ->where('sous_classes.id', $CompteId)->first();

        $Type ='<option value='.$Compte->Tid.'>'.$Compte->Class.' '.$Compte->Types.'</option>'; 
                foreach($TypeComptes as $TypeCompte){
                    $Type.='<option value='.$TypeCompte->id.'>'.$TypeCompte->Class.' '.$TypeCompte->Types.'</option>';
                }
        
        
        $TypeDetail =  $Compte->id.'#'.$Compte->Sclasse.'#'.$Compte->Intitule.'#'.$Type;

        echo  $TypeDetail;
    }

    public function Update_SousClass(Request $request){
        $SousCompte = SousClasse::findOrFail($request->Identifiant);
        $SousCompte->update([
            'Sclasse'=>$request->SClasse,
            'Intitule'=>$request->Intitule,
            'classe_id'=>$request->Classe
        ]);
        return back();
    }
}
