<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\NatureCompte;
use App\Models\Fourchette;
class NatureCompteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $NatureComptes  = NatureCompte::whereEtat(0)->get();
        return view('Comptabilite/NatureComptes.index', compact('NatureComptes'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $NatureCompte = New NatureCompte;
        return view('NatureComptes.create', compact('NatureCompte'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        NatureCompte::create([
            'nature'=>$request->nature,
            'tier'=>$request->tiers
        ]);
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $Fourchettes = Fourchette::whereNatureId($id)->get();
        return view('Comptabilite/NatureComptes.show', compact('Fourchettes', 'id'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $NatureCompte = NatureCompte::findOrFail($id);
        return view('NatureComptes.edit',compact('NatureCompte'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $NatureCompte = NatureCompte::findOrFail($id);
        $NatureCompte->update([
            'nature'=>$request->nature
        ]);

        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $NatureCompte = NatureCompte::findOrFail($id);
        $NatureCompte->destroy($id);
        return back();
    }

    public function getNatureCompteId(Request $request){
        $natureId = $request->get('nature');
        $NatureCompte = NatureCompte::findOrFail($natureId);
        
        if ($NatureCompte->tier==1) {
            $checkbox = '<label class="control-label">Plan Tiers</label>
                    <input type="checkbox" name="tiers" value="1" checked="checked"/>';
        }else{
            $checkbox = '<label class="control-label">Plan Tiers</label>
                    <input type="checkbox" name="tiers" value="1"/>';
        }
        

        $Input = $NatureCompte->nature.'#'.$checkbox;
    
        echo  $Input;
    }

    public function UpdateNatureCompte(Request $request){
        $Nature = NatureCompte::findOrFail($request->Identifiant);
        $Nature->update([
            'nature'=>$request->nature,
            'tier'=>$request->tiers
        ]);
        return redirect(route('NatureCompte.index'));
    }
}
