<?php
namespace App\Http\Controllers;
use App\Http\Requests\ExerciceComptableRequest;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Models\ExerciceComptable;
use App\Models\CompteGeneral;
use App\Models\Repportage;
use App\Interfaces\IRepportage as IRepportage;
use App\Interfaces\IExerciceComptable as IExerciceComptable;
use App\Models\CompteRepport;
use App\Models\Journal;
//use App\Http\Middleware\issetRepportedAccount;
use Illuminate\Support\Facades\DB;


class ExerciceComptableController extends Controller
{   

    public function __construct(IRepportage $Repportage, IExerciceComptable $ExerciceComptable){
        $this->Repportage = $Repportage;
        $this->ExerciceComptable = $ExerciceComptable;
        $this->middleware('guest');

        $this->middleware('permission:exercice-list|exercice-ajouter|exercice-modifier|exercice-supprimer', ['only' => ['index', 'show']]);
         $this->middleware('permission:exercice-ajouter', ['only' => ['create', 'store']]);
         $this->middleware('permission:exercice-modifier', ['only' => ['edit', 'update']]);
         $this->middleware('permission:exercice-supprimer', ['only' => ['destroy']]);
         $this->middleware('issetRepportedAccount', ['only' => ['CloseExercice']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $Ex = New ExerciceComptable;
        $Exercices = ExerciceComptable::whereEtat(0)->get();
        return view('Comptabilite/ExerciceComptable.index', compact('Exercices', 'Ex'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ExerciceComptableRequest $request)
    {  
       $NbreEx = ExerciceComptable::whereEtatAndCloturer(0,0)->count('id'); 
       if (ExerciceComptable::UniqueExercice($request->Debut,$request->Fin) == true) {

          if (ExerciceComptable::VerifyseparateurDecimalseparateurMilieu($request->SeparateurDecimal,$request->SeparateurMilieu)== true) {

            if (ExerciceComptable::VerifyNbreDecimal($request->NbreDecimal)== true ) {

                if ($NbreEx==0) {

                  ExerciceComptable::create([
                  'Debut'=>$request->Debut,
                  'Fin'=>$request->Fin,
                  'NbreDecimal'=>$request->NbreDecimal,
                  'separateurDecimal'=>$request->SeparateurDecimal,
                  'separateurMilieu'=>$request->SeparateurMilieu,
                  'Devise'=>$request->Devise,
                   ]);
                  $LastExercice = ExerciceComptable::whereEtat(0)->max('id');

                  //ON RECUPERE TOUS LES DONNEES A REPORTER
                  $Repportage = Journal::whereExercice(0)->get();
                  //ON DEBUTER LE REPORTAGE DES DONNEES
                  foreach ($Repportage as $Repport) {
                      $Repport->update([
                        'Exercice'=>$LastExercice
                      ]);
                  }
                }else{
                  session()->flash('messageDelete', 'Un autre Exercice est ouvert, Veuillez le Cloturer!');
                }
            }else{
                session()->flash('messageDelete', ' Le nombre de decimal doit etre compris entre 0 a 9');
            }
        }else{
           session()->flash('messageDelete', ' Le separateur Milieu et decimal doivent prendre la valeur , ou .'); 
        } 
       
     }else{
          session()->flash('messageDelete', 'Cet Exercice Comptable Existe!');
     }  
    return redirect(route('logout'));
  }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $ExerciceComptable = ExerciceComptable::findOrFail($id);
        return view('Comptabilite/ExerciceComptable.edit', compact('ExerciceComptable'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ExerciceComptableRequest $request, $id)
    {   
        $ExerciceComptable = ExerciceComptable::findOrFail($id);
        $ExerciceComptable->update([
            'Debut'=>$request->Debut,
            'Fin'=>$request->Fin,
            'NbreDecimal'=>$request->NbreDecimal,
            'separateurDecimal'=>$request->SeparateurDecimal,
            'separateurMilieu'=>$request->separateurMilieu,
            'Devise'=>$request->Devise,
        ]);
        return redirect(route('ExerciceComptable.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        $isUsed = $this->ExerciceComptable->isUsed($id);

        if ($isUsed==true) {
            $ExerciceComptable = ExerciceComptable::findOrFail($id);
            $ExerciceComptable->destroy($id);
        }else{
          session()->flash('messageDelete', 'L\'exercice que vous essayer de supprimer intervient dans certaines ecritures comptable.');
        }
        
        return redirect(route('ExerciceComptable.index'));
    }

    //Cloturer et Reouverture L'exercice Comptable 
    public function CloseExercice(Request $request){
      $ExerciceComptable = ExerciceComptable::findOrFail($request->Exerciceid);

      $mois = date('m');
      $Journal = DB::table('code_journauxes')
        ->join('journal_mensuelles', 'journal_mensuelles.journal_id', '=', 'code_journauxes.id')
        ->select(DB::raw('journal_mensuelles.id'))
        ->where('code_journauxes.ANouveau',1)
        ->where('journal_mensuelles.mois', $mois)
        ->first();

      //CLOTURE DES COMPTES DU BILAN
        $Comptesbilan = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->join('exercice_comptables', 'exercice_comptables.id', '=', 'journals.Exercice')
          ->select(DB::raw('sum(MD)-sum(MC) as Difference,compte_generals.id'))
          ->where('journals.Exercice', session()->get('ExerciceComptableId'))
          ->where('exercice_comptables.Editorial_mode', 0)
          ->where('compte_generals.type_compte', NULL)
          ->where('compte_generals.resultat_exercice', NULL)
          ->where('compte_generals.Repport', NULL)
          //->where('journals.Repported_Exercice', 0)
          ->groupBy('compte_generals.id')
          ->get();  

          foreach ($Comptesbilan as $key => $value) {
            if ($value->Difference<0) {
              Journal::create([
                'Compte'=>$value->id,
                'journal_id'=>$Journal->id,
                'TypeMvt'=>2,
                'DateOperation'=>date('Y-m-d'),
                'MC'=>$value->Difference*(-1),
                'MD'=>0,
                'Libelle'=>'A nouveau '.date('Y'),
                'Exercice_from'=>session()->get('ExerciceComptableId'),
                'created_by'=>auth()->user()->id,
                'updated_by'=>auth()->user()->id
              ]);
            }else{
              Journal::create([
                'Compte'=>$value->id,
                'journal_id'=>$Journal->id,
                'TypeMvt'=>1,
                'DateOperation'=>date('Y-m-d'),
                'MD'=>$value->Difference,
                'MC'=>0,
                'Libelle'=>'A nouveau '.date('Y'),
                'Exercice_from'=>session()->get('ExerciceComptableId'),
                'created_by'=>auth()->user()->id,
                'updated_by'=>auth()->user()->id
              ]);
            }
          }
      
      //CLOTURE DES COMPTES DES RESULTATS
        $ChargeD = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->select(DB::raw('*'))
          ->where('journals.Exercice', session()->get('ExerciceComptableId'))
          ->where('compte_generals.type_compte', 1)
          ->where('compte_generals.resultat_exercice', NULL)
          ->where('compte_generals.Repport', NULL)
          //->where('journals.Repported_Exercice', 0)
          ->sum('journals.MD');  

        $ChargeC = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->select(DB::raw(''))
          ->where('journals.Exercice', session()->get('ExerciceComptableId'))
          ->where('compte_generals.type_compte', 1)
          ->where('compte_generals.resultat_exercice', NULL)
          ->where('compte_generals.Repport', NULL)
          //->where('journals.Repported_Exercice', 0)
          ->sum('MC'); 

        $ProduitD = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->select(DB::raw('*'))
          ->where('journals.Exercice', session()->get('ExerciceComptableId'))
          ->where('compte_generals.type_compte', 2)
          ->where('compte_generals.resultat_exercice', NULL)
          ->where('compte_generals.Repport', NULL)
          //->where('journals.Repported_Exercice', 0)
          ->sum('journals.MD');  

        $ProduitC = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->select(DB::raw(''))
          ->where('journals.Exercice', session()->get('ExerciceComptableId'))
          ->where('compte_generals.type_compte', 2)
          ->where('compte_generals.resultat_exercice', NULL)
          ->where('compte_generals.Repport', NULL)
          //->where('journals.Repported_Exercice', 0)
          ->sum('MC');   

      $ResultatPreviews = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->select(DB::raw('journals.MC,journals.MD'))
          ->where('journals.Exercice', session()->get('ExerciceComptableId'))
          ->where('compte_generals.Repport', 2)
          ->Orwhere('compte_generals.Repport', 1)
          ->first(); 

      $Produit = $ProduitD-$ProduitC;
      $Charge = $ChargeD-$ChargeC;
      if (!is_null($ResultatPreviews)) {
        $Resultat = $Produit+$Charge+($ResultatPreviews->MD-$ResultatPreviews->MC);
      }else{
        $Resultat = $Produit+$Charge;
      }
             
        if ($Resultat<0) {
          $Compte_Repport =  CompteGeneral::where('Repport','=', 2)->first();
          Journal::create([
            'Compte'=>$Compte_Repport->id,
            'journal_id'=>$Journal->id,
            'TypeMvt'=>2,
            'DateOperation'=>date('Y-m-d'),
            'MC'=>$Resultat*(-1),
            'MD'=>0,
            'Libelle'=>'Resultat Exercice '.date('Y'),
            'Exercice_from'=>session()->get('ExerciceComptableId'),
            'created_by'=>auth()->user()->id,
            'updated_by'=>auth()->user()->id
          ]);
        }else{
          $Compte_Repport = CompteGeneral::where('Repport','=', 1)->first();
          Journal::create([
            'Compte'=>$Compte_Repport->id,
            'journal_id'=>$Journal->id,
            'TypeMvt'=>1,
            'DateOperation'=>date('Y-m-d'),
            'MC'=>0,
            'MD'=>$Resultat,
            'Libelle'=>'Resultat Exercice '.date('Y'),
            'Exercice_from'=>session()->get('ExerciceComptableId'),
            'created_by'=>auth()->user()->id,
            'updated_by'=>auth()->user()->id
          ]);
        }
      $ExerciceComptable->update([
        'Editorial_mode'=>1,
        'Cloturer'=>1
      ]);
      return redirect(route('ExerciceComptable.index'));
    }


    public function ReouvrirExercice($Exerciceid){
          $NbreEx = ExerciceComptable::whereEtatAndCloturer(0,0)->count('id');  
          $ExerciceComptable = ExerciceComptable::findOrFail($Exerciceid);
         //On verifie s'il y a un autre exercice ouvert
           if ($NbreEx==0) {
                $ExerciceComptable->update([
               'Cloturer'=>0
             ]);

             //Creation de la nouvelle session contenant l'Exercice reouverte
            $Exercice = ExerciceComptable::whereEtatAndCloturer(0,0)->first(); 
            session()->put('ExerciceComptableId', $Exercice->id);
            session()->put('ExerciceComptableDebut', $Exercice->Debut);
            session()->put('ExerciceComptableFin', $Exercice->Fin);
               
            }else{
            session()->flash('messageDelete', 'Un autre Exercice est ouvert, Veuillez le Cloturer!');
            }   
         return redirect(route('ExerciceComptable.index'));
    }
}
