<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\sectionAnalytique;
use App\Models\CompteGeneral;
use App\Models\CodeJournaux;
use DB;

class ControllersectionAnalytique extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $Sections = sectionAnalytique::all();
        return view('Comptabilite/Analytique/Section.index', compact('Sections'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        sectionAnalytique::create([
            'numero_compte'=>$request->Numero,
            'section'=>$request->Intitule
        ]);

        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function Ventillation(){
        $Sections = sectionAnalytique::all();
        return view('Comptabilite/Analytique/Section.ventillation', compact('Sections'));
    }

    public function Cost_centered(){
        $Comptes = CompteGeneral::all();
        $Codes = CodeJournaux::all();
        return view('Comptabilite/Etats.cost_centered_form', compact('Comptes', 'Codes'));
    }

    public function Cost_centered_edition(){
      $Periode = $_GET['debut'].' à '.$_GET['fin'];
      $EchelonCompt = '';
      $EchelonJour = '';
      $IncludeSituation = "";

        $TcdAux = 0;
        $TcdPrs = 0;
        $TciAux = 0;
        $TciPrs = 0;
        $TcpAux = 0;
        $TcpPrs = 0;
        $table1='';
        $table2='';

        $TotalSectionAux =DB::table('section_analytiques')
                    ->join('ventillations', 'ventillations.section_analytique_id', '=', 'section_analytiques.id')
                    ->select(DB::raw(''))
                    ->where('section_analytiques.type_centre',1)->sum('montant');
        $TotalSectionPrs =DB::table('section_analytiques')
                    ->join('ventillations', 'ventillations.section_analytique_id', '=', 'section_analytiques.id')
                    ->select(DB::raw(''))
                    ->where('section_analytiques.type_centre',2)->sum('montant');            
        
        $SectionAux =DB::table('section_analytiques')
                    ->select(DB::raw('CONCAT(section, "--" , numero_compte) AS full_name,id'))
                    ->where('section_analytiques.type_centre',1)->get();

        $SectionPris =DB::table('section_analytiques')
                    ->select(DB::raw('CONCAT(section, "--" , numero_compte) AS full_name,id'))
                    ->where('section_analytiques.type_centre',2)->get();

        $ChargeDirects =DB::table('etat_financiers')
                       ->select(DB::raw('intitule,id'))
                       ->where('type_etat', 'Analytique')
                       ->where('Positionnement', 'Charge Direct')->get();

        $ChargeIndirects =DB::table('etat_financiers')
                       ->select(DB::raw('intitule,id'))
                       ->where('type_etat', 'Analytique')
                       ->where('Positionnement', 'Charge Indirect')->get();

        $Produits =DB::table('etat_financiers')
                       ->select(DB::raw('intitule,id'))
                       ->where('type_etat', 'Analytique')
                       ->where('Positionnement', 'Produit')->get();                                                      

        foreach ($SectionAux as $SectionAu) {
       
           foreach ($ChargeDirects as $ChargeDirect) {
               
            $Montant =DB::table('etat_financier_contents')
              ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
              ->join('ventillations', 'ventillations.ecriture_id', '=', 'journals.id')
              ->where('etat_financier_contents.sous_rubrique_id',$ChargeDirect->id)
              ->where('ventillations.section_analytique_id',$SectionAu->id)
              ->whereBetween('ventillations.created_at', [$_GET['debut'],$_GET['fin']])
              ->sum('ventillations.montant');

              $table1.="<tr><td>".$ChargeDirect->intitule."</td> <td>".$Montant."</td> </tr>";
              $TcdAux += $Montant;
           }

           $table1.="<tr style='font-weight:bold;background-color:silver;'><td>Charges Directs</td><td>".$TcdAux."</td></tr>";
           

           foreach ($ChargeIndirects as $ChargeIndirect) {

               $Montant =DB::table('etat_financier_contents')
                 ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
                 ->join('ventillations', 'ventillations.ecriture_id', '=', 'journals.id')
                 ->where('etat_financier_contents.sous_rubrique_id',$ChargeIndirect->id)
                 ->where('ventillations.section_analytique_id',$SectionAu->id)
                 ->whereBetween('ventillations.created_at', [$_GET['debut'],$_GET['fin']])
                 ->sum('ventillations.montant');


               $table1.="<tr><td>".$ChargeIndirect->intitule."</td> <td>".$Montant."</td> </tr>";

               $TciAux += $Montant;
           }

           $table1.="<tr style='font-weight:bold;background-color:silver;'><td>Charges Indirects</td><td>".$TciAux."</td></tr>";

           foreach ($Produits as $Produit) {

               $Montant =DB::table('etat_financier_contents')
                 ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
                 ->join('ventillations', 'ventillations.ecriture_id', '=', 'journals.id')
                 ->where('etat_financier_contents.sous_rubrique_id',$Produit->id)
                 ->where('ventillations.section_analytique_id',$SectionAu->id)
                 ->whereBetween('ventillations.created_at', [$_GET['debut'],$_GET['fin']])
                 ->sum('ventillations.montant');

               $table1.="<tr><td>".$Produit->intitule."</td> <td>".$Montant."</td> </tr>";
               $TcpAux += $Montant;
           }
           
           $Tsection = ($TcpAux)-($TcdAux+$TciAux);

           $table1.="<tr style='font-weight:bold;background-color:silver;'><td>Produits</td><td>".$TcpAux."</td></tr>";
           $table1.="<tr style='font-weight:bold;background-color:black;color:white;'><td>".strtoupper($SectionAu->full_name)."</td><td>".$Tsection."</td></tr>";

           $TcdAux = 0;
           $TciAux = 0;
           $TcpAux = 0;
        }

        foreach ($SectionPris as $SectionP) {
           
           foreach ($ChargeDirects as $ChargeDirect) {

               $Montant =DB::table('etat_financier_contents')
                 ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
                 ->join('ventillations', 'ventillations.ecriture_id', '=', 'journals.id')
                 ->where('etat_financier_contents.sous_rubrique_id',$ChargeDirect->id)
                 ->where('ventillations.section_analytique_id',$SectionP->id)
                 ->whereBetween('ventillations.created_at', [$_GET['debut'],$_GET['fin']])
                 ->sum('ventillations.montant');

               $table2.="<tr><td>".$ChargeDirect->intitule."</td><td>".$Montant."</td></tr>";
               $TcdPrs += $Montant;
           }

           $table2.="<tr style='font-weight:bold;background-color:silver;'><td>Charges Directs</td><td>".$TcdPrs."</td></tr>";

           foreach ($ChargeIndirects as $ChargeIndirect) {

               $Montant =DB::table('etat_financier_contents')
                 ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
                 ->join('ventillations', 'ventillations.ecriture_id', '=', 'journals.id')
                 ->where('etat_financier_contents.sous_rubrique_id',$ChargeIndirect->id)
                 ->where('ventillations.section_analytique_id',$SectionP->id)
                 ->whereBetween('ventillations.created_at', [$_GET['debut'],$_GET['fin']])
                 ->sum('ventillations.montant');

               $table2.="<tr><td>".$ChargeIndirect->intitule."</td><td>".$Montant."</td></tr>";
               $TciPrs += $Montant;
           }

           $table2.="<tr style='font-weight:bold;background-color:silver;'><td>Charges Indirects</td><td>".$TciPrs."</td></tr>";

        
           foreach ($Produits as $Produit) {

               $Montant =DB::table('etat_financier_contents')
                 ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
                 ->join('ventillations', 'ventillations.ecriture_id', '=', 'journals.id')
                 ->where('etat_financier_contents.sous_rubrique_id',$Produit->id)
                 ->where('ventillations.section_analytique_id',$SectionP->id)
                 ->whereBetween('ventillations.created_at', [$_GET['debut'],$_GET['fin']])
                 ->sum('ventillations.montant');

               $table2.="<tr><td>".$Produit->intitule."</td><td>".$Montant."</td></tr>";
               $TcpPrs += $Montant;
           }
           
           $Tsection = ($TcpPrs)-($TcdPrs+$TciPrs);
           $table2.="<tr style='font-weight:bold;background-color:silver;'><td>Produits</td><td>".$TcpPrs."</td></tr>";
           $table2.="<tr style='font-weight:bold;background-color:black;color:white;'><td>".strtoupper($SectionP->full_name)."</td><td>".$Tsection."</td></tr>";

           $TcdPrs = 0;
           $TciPrs = 0;
           $TcpPrs = 0;

        }
        
        return view('Comptabilite/Etats.Cost_centered', compact('table1', 'table2', 'TotalSectionAux', 'TotalSectionPrs','Periode', 'EchelonCompt', 'EchelonJour', 'IncludeSituation'));
    }
}
