<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\CompteGeneral;
use App\Models\Tier;
use App\Http\Requests\ComptePrincipalRequest;
class CompteGeneralController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $CompteGenerals = CompteGeneral::all();
        return view('Comptabilite/CompteGenerals.index', compact('CompteGenerals'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ComptePrincipalRequest $request)
    {   
        if ($request->type_compte=='Charge') {
            CompteGeneral::create([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule,
                'type_compte'=>1,
                'tiers'=>NULL
            ]);
        }elseif ($request->type_compte=='Produit') {
            CompteGeneral::create([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule,
                'type_compte'=>2,
                'tiers'=>NULL
            ]);
        }elseif ($request->type_compte=='Tiers') {
            CompteGeneral::create([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule,
                'tiers'=>1,
                'type_compte'=>NULL
            ]);
        }else{
            CompteGeneral::create([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule,
                'tiers'=>NULL,
                'type_compte'=>NULL
            ]);
        }
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {   
        $CompteTiers = "";
        $IsNotEmpty = 'no';
        $Nbre = Tier::whereCompteId($id)->count('id');
        if ($Nbre!=0) {
            $IsNotEmpty = 'yes';
            $CompteTiers = Tier::whereCompteId($id)->get();
        }
        return view('Comptabilite/CompteGenerals.show', compact('CompteTiers', 'IsNotEmpty'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $CompteGeneral = CompteGeneral::findOrFail($id);
        $CompteGeneral->update([
            'numero_compte'=>$request->NumeroCompte,
            'Intitule'=>$request->Intitule
        ]);
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $CompteGeneral = CompteGeneral::findOrFail($id);
        $CompteGeneral->destroy($id);
        return back();
    }

    public function getCompteGeneralId(Request $request){
        $compteId = $request->get('compte');
        $Compte = CompteGeneral::findOrFail($compteId);
        
        if ($Compte->type_compte==1) {
            $Categorie = '<div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" checked="checked" value="Charge">
                  <label class="form-check-label" for="inlineRadio1">Charge</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Produit">
                  <label class="form-check-label" for="inlineRadio2">Produit</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Tiers">
                  <label class="form-check-label" for="inlineRadio3">Tiers</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte">
                  <label class="form-check-label" for="inlineRadio3">Aucun</label>
                </div>';
        }else if($Compte->type_compte==2){
             $Categorie = '<div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Charge">
                  <label class="form-check-label" for="inlineRadio1">Charge</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" checked="checked" name="type_compte" value="Produit">
                  <label class="form-check-label" for="inlineRadio2">Produit</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Tiers">
                  <label class="form-check-label" for="inlineRadio3">Tiers</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte">
                  <label class="form-check-label" for="inlineRadio3">Aucun</label>
                </div>';
        }else if($Compte->tiers==1){
            $Categorie = '<div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Charge">
                  <label class="form-check-label" for="inlineRadio1">Charge</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Produit">
                  <label class="form-check-label" for="inlineRadio2">Produit</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" checked="checked" value="Tiers">
                  <label class="form-check-label" for="inlineRadio3">Tiers</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte">
                  <label class="form-check-label" for="inlineRadio3">Aucun</label>
                </div>';
        }else{
            $Categorie = '<div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Charge">
                  <label class="form-check-label" for="inlineRadio1">Charge</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Produit">
                  <label class="form-check-label" for="inlineRadio2">Produit</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="type_compte" value="Tiers">
                  <label class="form-check-label" for="inlineRadio3">Tiers</label>
                </div>

                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" checked="checked" name="type_compte">
                  <label class="form-check-label" for="inlineRadio3">Aucun</label>
                </div>';
        }

        $Input = $Compte->numero_compte.'#'.$Compte->Intitule.'#'.$Categorie;
    
        echo  $Input;
    }

    public function UpdateCompteGeneral(ComptePrincipalRequest $request){
        $Compte = CompteGeneral::findOrFail($request->Identifiant);
        
        if ($request->type_compte=='Charge') {
            $Compte->update([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule,
                'type_compte'=>1
            ]);
        }elseif ($request->type_compte=='Produit') {
            $Compte->update([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule,
                'type_compte'=>2
            ]);
        }elseif ($request->type_compte=='Tiers') {
            $Compte->update([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule,
                'tiers'=>1
            ]);
        }else{
            $Compte->update([
                'numero_compte'=>$request->Numero,
                'Intitule'=>$request->Intitule
            ]);
        }
        return back();
    }

    public function compte_general_nature($id){
        $nature = 'bad';
        $Compte = CompteGeneral::findOrFail($id);
        if ($Compte->type_compte==1 OR $Compte->type_compte==2) {
            $nature = 'productorcharge';
        }elseif($Compte->tiers==1){
             $nature = 'tiers';
        }

        echo $nature;
    }
}
