@extends('layout.base')
@section('content')                        

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
              <div class="card-header">
                <h3 class="card-title">Sous Classes comptable</h3>
                @can('classe-create')
                <div class="row">
                  <div class="col-md-8"></div>
                  <div class="col-4">
                    <a href="javascript:void(0)" data-toggle="modal" data-target="#add-new-event" class="btn m-t-20 btn-info btn-block waves-effect waves-light">
                    <i class="ti-plus"></i> Nouveau Sous Classes
                    </a>
                  </div>
                </div>
                @endcan
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-striped">
                  <thead>



                                            <tr>
                                                <th>#</th>
                                                <th>Sous Classe</th>
                                                <th>Intitulé</th>
                                                <th>Classe</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                          @foreach($SClasses as $SClasse) 
                                               <tr>
                                                 <td>{{ $SClasse->id}}</td>
                                                 <td>{{ $SClasse->Sclasse}}</td>
                                                 <td>{{ $SClasse->Intitule }}</td>
                                                 <td>{{ $SClasse->Types }}</td>
                                                 
                                                 <td>
                                                @can('classe-edit')
                                                  <button data-toggle="modal" data-target="#add-older-event" value="{{$SClasse->id}}" onclick="getSClasse(this)">
                                                     <i class="fas fa-edit"></i>
                                                  </button>
                                                @endcan

                                                @can('classe-delete')
                                                <form action="{{route('Sclasse.destroy', $SClasse->id)}}" method='POST' style='display: inline-block;' onsubmit="return confirm('Etez-vous sur de cette Operation ?')">
                                                {{ csrf_field()}}
                                                {{method_field('DELETE')}}
                    
                                                <button onclick="return confirm('Etez -vous sur de cette Operation ?')"><i class='fas fa-trash'></i>
                                                </button>
                                               </form>
                                               @endcan

                                                 </td>
                                               </tr>
                                          @endforeach
                                      </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
            </div>
        </section>
      </div>
                     <!-- Modal Add Category -->
                <div class="modal fade none-border" id="add-new-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Creer une sous classe</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>
                        <form method="POST" action="{{ route('Sclasse.store')}}">
                            <div class="modal-body">
                               
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label class="control-label">Sous Classe *</label>
                                            <input class="form-control form-white" placeholder="Sous Classe compte" type="text" name="SClasse" />
                                            {!! $errors->first('Classe', '<span class="error">:message</span>') !!}

                                            <label class="control-label">Intitulé *</label>
                                            <input class="form-control form-white" placeholder="Intitule de la classe" type="text" name="Intitule" />
                                            {!! $errors->first('Intitule', '<span class="error">:message</span>') !!}

                                           <label class="col-md-3">Classe *</label>
                                    
                                        <select class="form-control select2" name="Classe">
                                            @foreach($Classes as $Classe)
                                                  <option value="{{ $Classe->id }}"> {{ $Classe->Class }} {{ $Classe->Types }}</option>
                                            @endforeach
                                        </select>

                                        {!! $errors->first('Classe', '<span class="error">:message</span>') !!}
                                        </div>
                                    </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>


                <div class="modal fade none-border" id="add-older-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Modifier une Sous classe</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>
                        <form method="POST" action="{{ route('Update_SousClass')}}">
                            <div class="modal-body">
                               
                                   {{ csrf_field() }}
                                   {{ method_field('PUT') }}
                                    <div class="row">
                                        <div class="col-md-12">
                                            <input type="text" name="Identifiant" id="Identifiant" style="display: none;">
                                            <label class="control-label">Classe *</label>
                                            <input class="form-control form-white" placeholder="Classe compte" type="text" name="SClasse" id="Classe" />
                                            {!! $errors->first('Classe', '<span class="error">:message</span>') !!}

                                            <label class="control-label">Intitulé *</label>
                                            <input class="form-control form-white" placeholder="Intitule de la classe" type="text" name="Intitule" id="Intitule" />
                                            {!! $errors->first('Intitule', '<span class="error">:message</span>') !!}

                                            <label class="control-label">Type de Classe *</label>
                                            <select class="form-control select2" name="Classe" id="RadionButt">
                                                
                                            </select>
                                            {!! $errors->first('Type', '<span class="error">:message</span>') !!}
                                        </div>
                                    </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>
                <!-- END MODAL -->
                </div>



                <!-- ============================================================== -->
                <!-- End PAge Content -->
                <!-- ============================================================== -->
                <!-- ============================================================== -->
                <!-- Right sidebar -->
                <!-- ============================================================== -->
                <!-- .right-sidebar -->
                <!-- ============================================================== -->
                <!-- End Right sidebar -->
                <!-- ============================================================== -->
            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->

                        @endsection

<script type="text/javascript">
  function getSClasse(va){
    var Sclasse= $(va).val();
    $.get('{{route('getSClasseId')}}',
    {Sclasse:Sclasse},
    function(data){
      var donnee = data.split("#");
      $("#Identifiant").val(donnee[0]);
      $("#Classe").val(donnee[1]);
      $("#Intitule").val(donnee[2]);
      $('#RadionButt').html(donnee[3]);
    });
  }
</script>                        