<?php

namespace App\Imports;

use App\Models\Repportage;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\ComptePrincipal;
class RepportageImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
      $Compte = ComptePrincipal::whereNumerocompteAndEtat($row['compte'],0)->first();
      if (!is_null($Compte)) {
          return new Repportage([
           'exercice_id'=> $row['exercice'],
           'compte_id'=> $Compte->id, 
           'montant'=> $row['montant'],
           'reported_in'=>$row['reported'],
           'type_mvt'=>$row['type']
          ]);
      }
    }
}
