<?php
 use App\Http\Middleware\ExerciceComptableExist;
 use App\Http\Middleware\InitialBilan;
 use App\Http\Middleware\CheckDatabaseConnection;
 use App\Http\Controllers\RoleController;
 use App\Http\Controllers\PermissionController;
 use App\Http\Controllers\CurrencyConverterController;
 use App\Http\Controllers\Auth\AuthController;
 use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

 // ROUTE POUR LA PAGE DE CONNEXION MST ET PARTENAIRE

Route::get('/', function () {
    return view('welcome');
});


Route::get('main-login', [AuthController::class, 'index'])->name('main_login');



Route::get('registration', [AuthController::class, 'registration'])->name('register');

Route::post('post-registration', [AuthController::class, 'postRegistration'])->name('register.post');  

Route::get('logout', [AuthController::class, 'logout'])->name('logout');


// MIDDLEWARE POUR VERIFIER SI LA BASE DE DONNEE EXISTES

Route::middleware([CheckDatabaseConnection::class])->group(function(){

Route::post('/file_upload', 'RepportageController@uploadfile')->name('uploadfile');
Route::post('post-login', [AuthController::class, 'postLogin'])->name('login.post'); 
//Route::post('/main/Verification', 'ConnexionController@Verification')->name('Verification');

Route::post('/main/VerifLogin', 'ConnexionController@VerifLogin')->name('VerifLogin');

Route::group(['middleware' => 'auth'], function(){

Route::get('/configuration_ms_syst', function () {
    return view('configuration');
})->name('configuration');

Route::get('/documentcomptable', function(){
    return view('documentcomptable');
})->name('documentcomptable');

Route::resource('Bien', 'bienController');
Route::resource('depreciationtype', 'depreciationtypeController');
Route::resource('sous_compte', 'SousCompteController');
Route::resource('Sclasse', 'SousClasseController');
Route::resource('Myfiles', 'MyfilesController');

Route::get('rapport_comptabilite', 'ComptabiliteController@rapport_comptabilite')->name('rapport_comptabilite');

Route::post('AttachAccount', 'PartenaireController@AttachAccount')->name('AttachAccount');

Route::get('/details_bilan/{periode}/{compte}', 'JournalController@details_bilan')->name('details_bilan');

Route::post('/depreciationForm', 'depreciationController@depreciationForm')->name('depreciationForm');
Route::get('/depreciationForm', 'depreciationController@depreciationForm')->name('depreciationForm');
Route::resource('depreciation', 'depreciationController');
Route::get('getTypeCompteId', 'TypeController@getTypeCompteId')->name('getTypeCompteId');

Route::get('/index', 'ComptabiliteController@index')->name('index');

Route::put('/update_result_configuration', 'JournalController@update_result_configuration')->name('update_result_configuration');
Route::get('/CorbUser', 'UtilisateurController@CorbUser')->name('CorbUser');
Route::get('/RestaurerUser/{User}', 'UtilisateurController@RestaurerUser')->name('RestaurerUser');
Route::resource('Utilisateurs', 'UtilisateurController');
Route::get('/restaureMotDePasse/{User}', 'UtilisateurController@restaureMotDePasse')->name('restaureMotDePasse');
Route::get('/ModifierMotdePasse', 'UtilisateurController@ModifierMotdePasse')->name('ModifierMotdePasse');
Route::put('/updateProfil', 'UtilisateurController@updateProfil')->name('updateProfil');


// ROUTES POUR LE MODULE DE COMPTABILITE

Route::get('/index', 'ComptabiliteController@index')->name('index');
 
Route::get('Balance', 'JournalController@Balance')->name('Balance');
Route::get('AfficherGdLivre', 'JournalController@AfficherGdLivre')->name('AfficherGdLivre');
Route::get('AfficherBalance', 'JournalController@AfficherBalance')->name('AfficherBalance');
Route::get('CompteResultat', 'JournalController@CompteResultat')->name('CompteResultat');
Route::get('Bilan', 'JournalController@Bilan')->name('Bilan');
Route::get('JournalPdf', 'JournalController@JournalPdf')->name('JournalPdf');
Route::post('JournalPdf', 'JournalController@JournalPdf')->name('JournalPdf');
 //});

Route::resource('ComptePrincipal', 'ComptePrincipalController');
Route::resource('Comptedivisionnaire', 'CompteSudbivisionnaireController');
Route::resource('ExerciceComptable', 'ExerciceComptableController');
Route::resource('TypeCompte', 'TypeController');
Route::resource('CodeJournaux','CodeJournauxController');
Route::resource('CompteJournal','CompteJournalController');
Route::resource('CompteRepport','CompteRepportController');
Route::resource('Parametre_generaux','ParametreController');
Route::resource('Repportage','RepportageController');

Route::get('apiCurrentConvert', [CurrencyConverterController::class, 'apiCurrentConvert'])->name('apiCurrentConvert');

Route::get('/uploadinjournalform', 'JournalController@uploadinjournalform')->name('uploadinjournalform');
Route::post('journal_file_upload', 'JournalController@journal_file_upload')->name('journal_file_upload');

Route::middleware([InitialBilan::class])->group(function(){
    Route::get('/uploadinitialbilanform', 'RepportageController@uploadinitialbilanform')->name('uploadinitialbilanform');
    Route::post('file_upload', 'RepportageController@uploadfile')->name('uploadfile');
});

Route::resource('Journal', 'JournalController');

Route::put('Update_typeCompte', 'TypeController@Update_typeCompte')->name('Update_typeCompte');
Route::put('Update_SousClass', 'SousClasseController@Update_SousClass')->name('Update_SousClass');
Route::put('UpdateComptePrincipal', 'ComptePrincipalController@UpdateComptePrincipal')->name('UpdateComptePrincipal');

Route::put('UpdateCompteSudb', 'CompteSudbivisionnaireController@UpdateCompteSudb')->name('UpdateCompteSudb');
Route::put('UpdateSousCompte', 'SousCompteController@UpdateSousCompte')->name('UpdateSousCompte');

//Route::get('SaisieNouveauForm','RepportageController@SaisieNouveauForm')->name('SaisieNouveauForm');
Route::get('researchComptesReported', 'CompteRepportController@researchComptesReported')->name('researchComptesReported');
Route::get('PlanComptable', 'JournalController@PlanComptable')->name('PlanComptable');



Route::post('CloseExercice', 'ExerciceComptableController@CloseExercice')->name('CloseExercice');
Route::get('ReouvrirExercice/{ExerciceId}', 'ExerciceComptableController@ReouvrirExercice')->name('ReouvrirExercice');

Route::get('AddACount/{Journal}', 'CompteJournalController@AddACount')->name('AddACount');
Route::post('attachedAccount', 'CompteRepportController@attachedAccount')->name('attachedAccount');
Route::put('dettachedAccount', 'CompteRepportController@dettachedAccount')->name('dettachedAccount');
Route::get('SettedAccountAsRepported/{Compte}', 'CompteRepportController@SettedAccountAsRepported')->name('SettedAccountAsRepported');
Route::get('SettedAccountAsJournal/{Compte}', 'CodeJournauxController@SettedAccountAsJournal')->name('SettedAccountAsJournal');

Route::post('attachedJournal', 'CodeJournauxController@attachedJournal')->name('attachedJournal');
Route::put('dettacheJournal', 'CodeJournauxController@dettacheJournal')->name('dettacheJournal');
Route::get('getComptePrincipalId', 'ComptePrincipalController@getComptePrincipalId')->name('getComptePrincipalId');

Route::get('getPermissionId', 'PermissionController@getPermissionId')->name('getPermissionId');

Route::get('getCompteSubdivislId', 'CompteSudbivisionnaireController@getCompteSubdivislId')->name('getCompteSubdivislId');
Route::get('getSCompteId', 'SousCompteController@getSCompteId')->name('getSCompteId');
Route::get('TransfererCompta/{ligne}', 'bienController@TransfererCompta')->name('TransfererCompta');
Route::get('Amortissement_sous_compte/{Compte}', 'CompteSudbivisionnaireController@Amortissement_sous_compte')->name('Amortissement_sous_compte');
Route::get('PlanAmortissement', 'depreciationController@PlanAmortissement')->name('PlanAmortissement');
Route::get('getSClasseId', 'SousClasseController@getSClasseId')->name('getSClasseId');

Route::get('getRepportageId', 'RepportageController@getRepportageId')->name('getRepportageId');
Route::put('depreciationtypeupdate', 'depreciationtypeController@depreciationtypeupdate')->name('depreciationtypeupdate');
Route::get('soldeJournalierForm', 'SoldeJournalierController@soldeJournalierForm')->name('soldeJournalierForm');
Route::put('SoldeJournalierAccount', 'SoldeJournalierController@SoldeJournalierAccount')->name('SoldeJournalierAccount');
Route::get('SoldeJournalier', 'SoldeJournalierController@SoldeJournalier')->name('SoldeJournalier');
Route::get('getSolde', 'SoldeJournalierController@getSolde')->name('getSolde');
Route::get('/solde_detail/{account}/{period}', 'SoldeJournalierController@solde_detail')->name('solde_detail');
Route::resource('SoldeJour', 'SoldeJournalierController');

Route::resource('guichet', 'GuichetController');
Route::get('Brouillard', 'JournalController@Brouillard')->name('Brouillard'); 


//ROUTES POUR LA GESTION DES DROITS D'ACCESS AU SYSTEME MS
    Route::resource('modules', 'ModuleController');
    Route::resource('roles', 'RoleController');
    Route::resource('permissions', 'PermissionController');
    Route::post('add_permission', 'UtilisateurController@add_permission')->name('add_permission');
});

});


